/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.ColinearPoints2DException;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CircleLine2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.CirculinearRing2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.conic.CircularShape2D;
import math.geom2d.conic.Conic2D;
import math.geom2d.conic.Ellipse2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circle2D
extends Ellipse2D
implements Cloneable,
CirculinearElement2D,
CirculinearRing2D,
CircularShape2D,
CircleLine2D {
    protected double r = 0.0;

    public static Circle2D create(Point2D center, double radius) {
        return new Circle2D(center, radius);
    }

    public static Circle2D create(Point2D center, double radius, boolean direct) {
        return new Circle2D(center, radius, direct);
    }

    public static Circle2D create(Point2D p1, Point2D p2, Point2D p3) {
        if (Point2D.isColinear(p1, p2, p3)) {
            throw new ColinearPoints2DException(p1, p2, p3);
        }
        StraightLine2D line12 = StraightLine2D.createMedian(p1, p2);
        StraightLine2D line23 = StraightLine2D.createMedian(p2, p3);
        assert (!AbstractLine2D.isParallel(line12, line23)) : "If points are not colinear, medians should not be parallel";
        Point2D center = AbstractLine2D.getIntersection(line12, line23);
        double radius = Point2D.getDistance(center, p2);
        return new Circle2D(center, radius);
    }

    public static Collection<Point2D> getIntersections(Circle2D circle1, Circle2D circle2) {
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Point2D center1 = circle1.getCenter();
        Point2D center2 = circle2.getCenter();
        double r1 = circle1.getRadius();
        double r2 = circle2.getRadius();
        double d = Point2D.getDistance(center1, center2);
        if (d < Math.abs(r1 - r2) | d > r1 + r2) {
            return intersections;
        }
        double angle = Angle2D.getHorizontalAngle(center1, center2);
        double d1 = d / 2.0 + (r1 * r1 - r2 * r2) / (2.0 * d);
        Point2D tmp = Point2D.createPolar(center1, d1, angle);
        double h = Math.sqrt(r1 * r1 - d1 * d1);
        intersections.add(Point2D.createPolar(tmp, h, angle + 1.5707963267948966));
        intersections.add(Point2D.createPolar(tmp, h, angle - 1.5707963267948966));
        return intersections;
    }

    public static Collection<Point2D> getIntersections(CircularShape2D circle, LinearShape2D line) {
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Circle2D parent = circle.getSupportingCircle();
        Point2D center = parent.getCenter();
        double radius = parent.getRadius();
        StraightLine2D perp = StraightLine2D.createPerpendicular(line, center);
        Point2D inter = perp.getIntersection(new StraightLine2D(line));
        assert (inter != null);
        double dist = inter.getDistance(center);
        if (Math.abs(dist - radius) < 1.0E-12) {
            if (line.contains(inter) && circle.contains(inter)) {
                intersections.add(inter);
            }
            return intersections;
        }
        double angle = line.getHorizontalAngle();
        double d2 = Math.sqrt(radius * radius - dist * dist);
        Point2D p1 = Point2D.createPolar(inter, d2, angle + Math.PI);
        Point2D p2 = Point2D.createPolar(inter, d2, angle);
        if (line.contains(p1) && circle.contains(p1)) {
            intersections.add(p1);
        }
        if (line.contains(p2) && circle.contains(p2)) {
            intersections.add(p2);
        }
        return intersections;
    }

    public Circle2D() {
        this(0.0, 0.0, 0.0, true);
    }

    public Circle2D(Point2D center, double radius) {
        this(center.getX(), center.getY(), radius, true);
    }

    public Circle2D(Point2D center, double radius, boolean direct) {
        this(center.getX(), center.getY(), radius, direct);
    }

    public Circle2D(double xcenter, double ycenter, double radius) {
        this(xcenter, ycenter, radius, true);
    }

    public Circle2D(double xcenter, double ycenter, double radius, boolean direct) {
        super(xcenter, ycenter, radius, radius, 0.0, direct);
        this.r = radius;
    }

    public double getRadius() {
        return this.r;
    }

    public Collection<Point2D> getIntersections(Circle2D circle) {
        return Circle2D.getIntersections(this, circle);
    }

    @Override
    public Circle2D getSupportingCircle() {
        return this;
    }

    @Override
    public Conic2D.Type getConicType() {
        return Conic2D.Type.CIRCLE;
    }

    @Override
    public boolean isCircle() {
        return true;
    }

    @Override
    public double[] getConicCoefficients() {
        return new double[]{1.0, 0.0, 1.0, -2.0 * this.xc, -2.0 * this.yc, this.xc * this.xc + this.yc * this.yc - this.r * this.r};
    }

    @Override
    public double getEccentricity() {
        return 0.0;
    }

    @Override
    public Point2D getFocus1() {
        return new Point2D(this.xc, this.yc);
    }

    @Override
    public Point2D getFocus2() {
        return new Point2D(this.xc, this.yc);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public Circle2D getParallel(double d) {
        double rp = Math.max(this.direct ? this.r + d : this.r - d, 0.0);
        return new Circle2D(this.xc, this.yc, rp, this.direct);
    }

    @Override
    public double getLength() {
        return this.r * Math.PI * 2.0;
    }

    @Override
    public double getLength(double pos) {
        return pos * this.r;
    }

    @Override
    public double getPosition(double length) {
        return length / this.r;
    }

    @Override
    public CircleLine2D transform(CircleInversion2D inv) {
        Point2D c1;
        Point2D center = inv.getCenter();
        if (center.getDistance(c1 = this.getCenter()) < 1.0E-12) {
            double r0 = inv.getRadius();
            double r2 = r0 * r0 / this.r;
            return new Circle2D(center, r2, this.direct);
        }
        StraightLine2D centersLine = new StraightLine2D(center, c1);
        Collection<Point2D> points = this.getIntersections(centersLine);
        Iterator<Point2D> iter = points.iterator();
        Point2D p1 = iter.next();
        Point2D p2 = iter.next();
        if (this.getDistance(center) < 1.0E-12) {
            double dist2;
            double dist1 = center.getDistance(p1);
            Point2D p0 = dist1 < (dist2 = center.getDistance(p2)) ? p2 : p1;
            p0 = p0.transform(inv);
            return StraightLine2D.createPerpendicular(centersLine, p0);
        }
        p1 = p1.transform(inv);
        p2 = p2.transform(inv);
        double diam = p1.getDistance(p2);
        c1 = Point2D.midPoint(p1, p2);
        return new Circle2D(c1, diam / 2.0, !this.isDirect());
    }

    @Override
    public Vector2D getTangent(double t) {
        if (!this.direct) {
            t = -t;
        }
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        if (this.direct) {
            return new Vector2D(-this.r * sint * cot - this.r * cost * sit, -this.r * sint * sit + this.r * cost * cot);
        }
        return new Vector2D(this.r * sint * cot + this.r * cost * sit, this.r * sint * sit - this.r * cost * cot);
    }

    public Collection<? extends Circle2D> getSmoothPieces() {
        return Circle2D.wrapCurve(this);
    }

    @Override
    public boolean isInside(Point2D point) {
        double yp;
        double xp = (point.getX() - this.xc) / this.r;
        return xp * xp + (yp = (point.getY() - this.yc) / this.r) * yp < 1.0 ^ !this.direct;
    }

    @Override
    public double getSignedDistance(Point2D point) {
        return this.getSignedDistance(point.getX(), point.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        if (this.direct) {
            return Point2D.getDistance(this.xc, this.yc, x, y) - this.r;
        }
        return this.r - Point2D.getDistance(this.xc, this.yc, x, y);
    }

    @Override
    public Point2D getPoint(double t) {
        double angle = this.theta + t;
        if (!this.direct) {
            angle = this.theta - t;
        }
        return new Point2D(this.xc + this.r * Math.cos(angle), this.yc + this.r * Math.sin(angle));
    }

    @Override
    public Point2D getFirstPoint() {
        return new Point2D(this.xc + this.r * Math.cos(this.theta), this.yc + this.r * Math.sin(this.theta));
    }

    @Override
    public Point2D getLastPoint() {
        return new Point2D(this.xc + this.r * Math.cos(this.theta), this.yc + this.r * Math.sin(this.theta));
    }

    @Override
    public double getPosition(Point2D point) {
        double angle = Angle2D.getHorizontalAngle(this.xc, this.yc, point.getX(), point.getY());
        if (this.direct) {
            return Angle2D.formatAngle(angle - this.theta);
        }
        return Angle2D.formatAngle(this.theta - angle);
    }

    @Override
    public Circle2D getReverseCurve() {
        return new Circle2D(this.getCenter().getX(), this.getCenter().getY(), this.getRadius(), !this.direct);
    }

    @Override
    public CircleArc2D getSubCurve(double t0, double t1) {
        double extent;
        double startAngle;
        if (this.direct) {
            startAngle = t0;
            extent = Angle2D.formatAngle(t1 - t0);
        } else {
            extent = -Angle2D.formatAngle(t1 - t0);
            startAngle = Angle2D.formatAngle(-t0);
        }
        return new CircleArc2D(this, startAngle, extent);
    }

    public Collection<? extends Circle2D> getContinuousCurves() {
        return Circle2D.wrapCurve(this);
    }

    @Override
    public double getDistance(Point2D point) {
        return Math.abs(Point2D.getDistance(this.xc, this.yc, point.getX(), point.getY()) - this.r);
    }

    @Override
    public double getDistance(double x, double y) {
        return Math.abs(Point2D.getDistance(this.xc, this.yc, x, y) - this.r);
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        return Circle2D.getIntersections((CircularShape2D)this, line);
    }

    @Override
    public CurveSet2D<? extends CircularShape2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<AbstractSmoothCurve2D> result = new CurveArray2D<AbstractSmoothCurve2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (curve2D instanceof CircleArc2D) {
                result.addCurve((CircleArc2D)curve2D);
            }
            if (!(curve2D instanceof Circle2D)) continue;
            result.addCurve((Circle2D)curve2D);
        }
        return result;
    }

    @Override
    public boolean contains(double x, double y) {
        return Math.abs(this.getDistance(x, y)) <= 1.0E-12;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        if (this.direct) {
            double t = 0.1;
            while (t < Math.PI * 2) {
                double cost = Math.cos(t);
                double sint = Math.sin(t);
                path.lineTo((float)(this.xc + this.r * cost * cot - this.r * sint * sit), (float)(this.yc + this.r * cost * sit + this.r * sint * cot));
                t += 0.1;
            }
        } else {
            double t = 0.1;
            while (t < Math.PI * 2) {
                double cost = Math.cos(t);
                double sint = Math.sin(t);
                path.lineTo((float)(this.xc + this.r * cost * cot + this.r * sint * sit), (float)(this.yc + this.r * cost * sit - this.r * sint * cot));
                t += 0.1;
            }
        }
        path.lineTo((float)(this.xc + this.r * cot), (float)(this.yc + this.r * sit));
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.xc - this.r, this.yc - this.r, 2.0 * this.r, 2.0 * this.r);
        g2.draw(ellipse);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (!(obj instanceof Ellipse2D)) {
            return false;
        }
        if (obj instanceof Circle2D) {
            Circle2D circle = (Circle2D)obj;
            if (Math.abs(circle.xc - this.xc) > eps) {
                return false;
            }
            if (Math.abs(circle.yc - this.yc) > eps) {
                return false;
            }
            if (Math.abs(circle.r - this.r) > eps) {
                return false;
            }
            return circle.direct == this.direct;
        }
        return super.almostEquals(obj, eps);
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "Circle2D(%7.2f,%7.2f,%7.2f,%s)", this.xc, this.yc, this.r, this.direct ? "true" : "false");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Ellipse2D)) {
            return false;
        }
        if (obj instanceof Circle2D) {
            Circle2D circle = (Circle2D)obj;
            if (Math.abs(circle.xc - this.xc) > 1.0E-12) {
                return false;
            }
            if (Math.abs(circle.yc - this.yc) > 1.0E-12) {
                return false;
            }
            if (Math.abs(circle.r - this.r) > 1.0E-12) {
                return false;
            }
            return circle.direct == this.direct;
        }
        return super.equals(obj);
    }

    @Override
    public Circle2D clone() {
        return new Circle2D(this.xc, this.yc, this.r, this.direct);
    }
}

